/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Port.h
  \brief    	This file contains all Port Configuration structures as well as \n
              definitions to initialize GPIO pins as outputs.
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	4/14/2008 5:37:45 PM
  \warning    User must be aware about which GPIO pins shall be used as Pwm channels.
  
  * History:
  
*/
#ifndef PORT_H
 #define PORT_H
 
 #include "Pwm_Cfg.h"
 #include "Derivative.h"
 /*----------------------------- Defines ------------------------*/
 /** Set pins as Outputs with Maximum Slew Rate */
 #define SET_AS_OUTPUT                             (0x020C)
 /** Set Pin as Input state                     */
 #define SET_AS_INPUT                              ((uint16_t)(0x0500))
 /** MPC551x SIU PCR Address. Violates MISRA 2004 rule 11.3 because addressing memory mapped registers */
 #define SIU_PCR_ADDR(PCR_OFFSET, u8State)                  (SIU_PCR(PCR_OFFSET) = (uint16_t)(u8State))  
 /** This macro helps to SET or CLEAR the passed GPDO pin. Violates MISRA 2004 rule 11.3 because addressing memory mapped registers */
 #define SIU_GPDO_ADDR(GPDO_OFFSET,u8OutputState)  (SIU_GPDO(GPDO_OFFSET) = (uint8_t)(u8OutputState))
 /** Toggle Port Pin */
 #define TOGGLE_PIN(GPDO_OFFSET)                   (SIU_GPDO(GPDO_OFFSET) = ((1) ^ (SIU_GPDO(GPDO_OFFSET))))
 /** Set pin to ON state */
 #define SET_PIN_HIGH(GPDO_OFFSET)                 (SIU_GPDO(GPDO_OFFSET) = (uint8_t)(1))
 /** Clear current pin state*/                      
 #define SET_PIN_LOW(GPDO_OFFSET)                  (SIU_GPDO(GPDO_OFFSET) = (uint8_t)(0))
 /*----------------------------- Function ------------------------*/
 void vfnPort_Init(const Pwm_ChannelConfigType *PortCfgPtr);
 
 #endif